<?php

namespace App\Models\QuizAnswer;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class QuizAnswer extends Model 
{

    protected $table = 'quiz_answers';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('question_id', 'answer', 'correct');

    public function quiz()
    {
        return $this->belongsTo('Quiz', 'quiz_id');
    }

}